/**
 * Sites类只涉及与pc进行数据交换，不参与html
 * 注意下文中get，edit等接口的约定，实现相关接口的方法
 * 
 */
/*接口约定
 * Interface get{
 * 		function getSites();
 * }
 * Interface edit{
 * 		function modifySite();
 * 		function deleteSite();
 * }
 * Interface display{
 * 		function showSites();
 * 		function bindEvent();
 * }
 * Interface save{
 * 		function saveSites();
 * }
 */
var Sites = function(len){
	var LEN = len || 9;
	var get = {};        //interface get
	var edit = {};       //interface edit
	var save = {};       //interface save
	
	this.sites = new Array(LEN); //开放sites
	
	this.setGet = function(Get){
		get = Get;
	};
	this.setEdit = function(Edit){
		edit = Edit;
	};
	this.setSave = function(Save){
		save = Save;
	};
	/**
	 * 调用接口完成初始化
	 */
	this.setSites = function(){
		var returnSites = get.getSites();
		if(returnSites.length == null){
			throw 'implement error';
			return ;
		}
		for(var i=0;i<LEN;++i){
			this.sites[i] = new webSite();
			this.sites[i].setSiteWithOBJ(returnSites[i]);
		}
	};
	/**
	 * 编辑站点
	 * @param index:编辑第几个站点，handle:增删插改
	 */
	this.editSites = function(index,handle,obj){
		switch(handle){
		case 'add':
			this.sites[this.sites.length] = edit.addSite.call(this,index);
		case 'delete':
			for(var i = index;i<this.sites.length-1;i++){
				this.sites[i].setSiteWithOBJ(this.sites[i+1].getOBJofSites());
			}
			if(edit.deleteSite.call(this,index,obj)){ // true:保留最后一个元素，用obj设置，false length-1
				this.sites[this.sites.length-1].setSiteWithOBJ(obj);
			}else{
				this.sites.length -= 1;
			}
			edit.deleteSite.call(this,index);
			break;
		case 'modify':
			this.sites[index].setSiteWithOBJ(edit.modifySite.call(this,index,obj));
			break;
		case 'insert':
			for(var i=this.sites.length;i>index;--i){
				this.sites[i].setSiteWithOBJ(this.sites[i-1].getOBJofSites());
			}
			this.sites[index].setSiteWithOBJ(edit.modifySite.call(this,index));
		default:
			throw 'invalid handle';
		}
	};
	/**
	 * 完成站点的存储以便下次浏览器打开时的读取
	 */
	this.saveSites = function (){
		save.saveSites.call(this,this.sites);
	};
	this.getSites = function(){
		return this.sites;
	};
};